/*	MikMod sound library
	(c) 1998-2001 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

/*==============================================================================

  $Id: drv_ds.c,v 1.8 2002/01/08 21:03:13 miod Exp $

  Driver for output on win32 platforms using DirectSound

==============================================================================*/

/*

	Written by Brian McKinney <Brian.McKinney@colorado.edu>

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#define DRV_DS

#ifdef DRV_DS

#include <memory.h>
#include <string.h>

#define INITGUID

#include "dsound.h"

#include "mikmod_internals.h"

/* DSBCAPS_CTRLALL is not defined anymore with DirectX 7. Of course DirectSound
   is a coherent, backwards compatible API... */
#ifndef DSBCAPS_CTRLALL
#define DSBCAPS_CTRLALL ( DSBCAPS_CTRLPOSITIONNOTIFY | DSBCAPS_CTRLVOLUME | \
				          DSBCAPS_CTRLFREQUENCY )
#endif

/* size of each buffer */
#define FRAGSIZE 16
/* buffer count */
#define UPDATES  2

/* sleep time (in milliseconds) */
#define	SLEEPINTERVAL	20		/* 20Hz */

static LPDIRECTSOUND pSoundCard = NULL;
static LPDIRECTSOUNDBUFFER pPrimarySoundBuffer = NULL, pSoundBuffer = NULL;
static LPDIRECTSOUNDNOTIFY pSoundBufferNotify = NULL;

static HANDLE notifyUpdateHandle = 0, updateBufferHandle = 0;
static DWORD updateBufferThreadID = 0, soundBufferCurrentPosition = 0;
static DWORD blockBytes1 = 0,blockBytes2 = 0;
static LPVOID pBlock1 = NULL, pBlock2 = NULL;
static BOOL threadInUse = FALSE;
static int fragsize=0x20000;
static DWORD controlflags = DSBCAPS_CTRLALL;

#define SAFE_RELEASE(p) \
	do { \
		if (p) { \
			if ((p)) { \
				(p)->Release(); \
				(p) = NULL;	\
			} \
		} \
	} while (0)

BOOL threadRunning = FALSE;

static DWORD WINAPI updateBufferProc(LPVOID lpParameter)
{
	threadRunning = TRUE;

	while(threadInUse) {
//		if(WaitForSingleObject(notifyUpdateHandle,20)==WAIT_OBJECT_0) {
			//ResetEvent(notifyUpdateHandle);
			while (soundBufferCurrentPosition<fragsize)
			pSoundBuffer->GetCurrentPosition(&soundBufferCurrentPosition,NULL);
//			if(soundBufferCurrentPosition<fragsize)
			
			VC_WriteBytes((SBYTE*)pBlock1,(ULONG)blockBytes1);

			while(soundBufferCurrentPosition>=fragsize)
			pSoundBuffer->GetCurrentPosition(&soundBufferCurrentPosition,NULL);
			
			VC_WriteBytes((SBYTE*)pBlock2,(ULONG)blockBytes1);
//		}
/*
			}else {

				if(Player_Paused()) {

						VC_SilenceBytes((SBYTE*)pBlock1,(ULONG)blockBytes1);
						if(pBlock2)
							VC_SilenceBytes((SBYTE*)pBlock2,(ULONG)blockBytes2);

				} else {

						VC_WriteBytes((SBYTE*)pBlock1,(ULONG)blockBytes1);
						if(pBlock2)
							VC_WriteBytes((SBYTE*)pBlock2,(ULONG)blockBytes2);

				}
			
			}*/
//		}
	}
	threadRunning = FALSE;
	return 0;
}

static void DS_WaitForThreadEnd(void)
{
	threadInUse = 0;
	if (updateBufferHandle && threadRunning)
			while (threadRunning == TRUE)
					Sleep(0);
	if (pSoundBuffer)
		pSoundBuffer->Stop();
}

static void DS_CommandLine(CHAR *cmdline)
{
	CHAR *ptr=MD_GetAtom("buffer",cmdline,0);

	if(ptr) {
		int buf=atoi(ptr);

		if((buf<12)||(buf>19)) buf=FRAGSIZE;
		fragsize=1<<buf;

		free(ptr);
	}
	
	if ((ptr=MD_GetAtom("globalfocus",cmdline,1))) {
		controlflags |= 0;
		free(ptr);
	}
}

BOOL DS_IsPresent(void)
{
	if(DirectSoundCreate(NULL,&pSoundCard,NULL)!=DS_OK)
		return 0;
	SAFE_RELEASE(pSoundCard);
	return 1;
}

BOOL DS_Init(void)
{
	DSBUFFERDESC soundBufferFormat;
	WAVEFORMATEX pcmwf;
	DSBPOSITIONNOTIFY positionNotifications[2];

	if(DirectSoundCreate(NULL,&pSoundCard,NULL)!=DS_OK) {
		_mm_errno=MMERR_OPENING_AUDIO;
		return 1;
	}

	
	memset(&pcmwf,0,sizeof(WAVEFORMATEX));
    pcmwf.wFormatTag     =WAVE_FORMAT_PCM;
    pcmwf.nChannels      =(md_mode&DMODE_STEREO)?2:1;
    pcmwf.nSamplesPerSec =md_mixfreq;
    pcmwf.wBitsPerSample =(md_mode&DMODE_16BITS)?16:8;
    pcmwf.nBlockAlign    =(pcmwf.wBitsPerSample * pcmwf.nChannels) / 8;
    pcmwf.nAvgBytesPerSec=pcmwf.nSamplesPerSec*pcmwf.nBlockAlign;
   
	memset(&soundBufferFormat,0,sizeof(DSBUFFERDESC));
    soundBufferFormat.dwSize       =sizeof(DSBUFFERDESC);
    soundBufferFormat.dwFlags      =0;
    soundBufferFormat.dwBufferBytes=0;                                
    soundBufferFormat.lpwfxFormat  =NULL; 
/*	
	if(pSoundCard->CreateSoundBuffer
	         (&soundBufferFormat,&pPrimarySoundBuffer,NULL)!=DS_OK) {
		_mm_errno=MMERR_DS_BUFFER;
		return 1;
	}

    if(pPrimarySoundBuffer->SetFormat(&pcmwf)!=DS_OK) {
		_mm_errno=MMERR_DS_FORMAT;
		return 1;
	}
    pPrimarySoundBuffer->Play(0,0,DSBPLAY_LOOPING);
*/ 	
	memset(&pcmwf,0,sizeof(WAVEFORMATEX));
    pcmwf.wFormatTag     =WAVE_FORMAT_PCM;
    pcmwf.nChannels      =(md_mode&DMODE_STEREO)?2:1;
    pcmwf.nSamplesPerSec =md_mixfreq;
    pcmwf.wBitsPerSample =(md_mode&DMODE_16BITS)?16:8;
    pcmwf.nBlockAlign    =(pcmwf.wBitsPerSample * pcmwf.nChannels) / 8;
    pcmwf.nAvgBytesPerSec=pcmwf.nSamplesPerSec*pcmwf.nBlockAlign;

	memset(&soundBufferFormat,0,sizeof(DSBUFFERDESC));
    soundBufferFormat.dwSize       =sizeof(DSBUFFERDESC);
    soundBufferFormat.dwFlags      =DSBCAPS_CTRLPOSITIONNOTIFY ;
    soundBufferFormat.dwBufferBytes=fragsize*2;
    soundBufferFormat.lpwfxFormat  =&pcmwf;
	
	if(pSoundCard->CreateSoundBuffer
	                (&soundBufferFormat,&pSoundBuffer,NULL)!=DS_OK) {
		_mm_errno=MMERR_DS_BUFFER;
		return 1;
	}
//	pSoundBuffer->QueryInterface
//	        (&IID_IDirectSoundNotify,(LPVOID*)&pSoundBufferNotify);
//	if(!pSoundBufferNotify) {
//		_mm_errno=MMERR_DS_NOTIFY;
//		return 1;
//	}

	notifyUpdateHandle=CreateEvent
	     (NULL,FALSE,TRUE,"Notify Event");
	if(!notifyUpdateHandle) {
		_mm_errno=MMERR_DS_EVENT;
		return 1;
	}

	updateBufferHandle=CreateThread
	      (NULL,0,updateBufferProc,NULL,CREATE_SUSPENDED,&updateBufferThreadID);
	if(!updateBufferHandle) {
		_mm_errno=MMERR_DS_THREAD;
		return 1;
	}
	XSetProcessQuantumLength(1);

	pBlock1=VirtualAlloc(NULL,fragsize*2,MEM_COMMIT,PAGE_READWRITE);
	pBlock2=(CHAR*)pBlock1+fragsize;
	pSoundBuffer->SetBufferData(pBlock1,fragsize*2);
//    pSoundBuffer->Play(0,0,DSBPLAY_LOOPING|DSBPLAY_FROMSTART);
	blockBytes1=fragsize;
	blockBytes2=fragsize;

	memset(positionNotifications,0,2*sizeof(DSBPOSITIONNOTIFY));
	positionNotifications[0].dwOffset    =DSBPN_OFFSETSTOP;
	positionNotifications[0].hEventNotify=notifyUpdateHandle;
	positionNotifications[1].dwOffset    =4000;
	positionNotifications[1].hEventNotify=notifyUpdateHandle;
	pSoundBuffer->SetNotificationPositions(2,positionNotifications);


	if(VC_Init())
		return 1;

	return 0;
}

void DS_Exit(void)
{
	DWORD statusInfo;

	DS_WaitForThreadEnd();

	if(updateBufferHandle) {
		CloseHandle(updateBufferHandle),
		updateBufferHandle = 0;
	}
	if (notifyUpdateHandle) {
		CloseHandle(notifyUpdateHandle),
		notifyUpdateHandle = 0;
	}
	
	VC_Exit();

	SAFE_RELEASE(pSoundBufferNotify);
	if(pSoundBuffer) {
		if(pSoundBuffer->GetStatus(&statusInfo)==DS_OK)
			if(statusInfo&DSBSTATUS_PLAYING)
				pSoundBuffer->Stop();
		SAFE_RELEASE(pSoundBuffer);
	}

	if(pPrimarySoundBuffer) {
		if(pPrimarySoundBuffer->GetStatus
		                               (&statusInfo)==DS_OK)
			if(statusInfo&DSBSTATUS_PLAYING)
				pPrimarySoundBuffer->Stop();
		SAFE_RELEASE(pPrimarySoundBuffer);
	}

	SAFE_RELEASE(pSoundCard);
}

void DS_Update(void)
{
	return;
}

void DS_PlayStop(void)
{
	DS_WaitForThreadEnd();

	VC_PlayStop();
}

BOOL DS_PlayStart(void)
{
	pSoundBuffer->Play(0,0,DSBPLAY_LOOPING|DSBPLAY_FROMSTART);
	threadInUse=1;
	threadRunning = TRUE;
	ResumeThread(updateBufferHandle);
	VC_PlayStart();

	return 0;
}

MIKMODAPI MDRIVER drv_ds=
{
	NULL,
	"DirectSound",
	"DirectSound Driver (DX6+) v0.3",
	0,255,
	"ds",

	DS_CommandLine,
	DS_IsPresent,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	DS_Init,
	DS_Exit,
	NULL,
	VC_SetNumVoices,
	DS_PlayStart,
	DS_PlayStop,
	DS_Update,
	NULL,
	VC_VoiceSetVolume,
	VC_VoiceGetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceGetFrequency,
	VC_VoiceSetPanning,
	VC_VoiceGetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};

#else

MISSING(drv_ds);

#endif

extern "C" char *modulefileptr,*modulefileendptr;

//extern "C" int MikModSetup(void);
/*
typedef struct MREADER {
	BOOL (*Seek)(struct MREADER*,long,int);
	long (*Tell)(struct MREADER*);
	BOOL (*Read)(struct MREADER*,void*,size_t);
	int  (*Get)(struct MREADER*);
	BOOL (*Eof)(struct MREADER*);
} MREADER;
*/
FILE mymod;
BOOL myseek(MREADER *fp,long offset,int whence)
{
	if (whence==0)
	mymod._cnt=offset;
	else
	mymod._cnt=mymod._cnt+offset;
	return 0;
};
long mytell(MREADER *fp)
{
	return mymod._cnt;
};
BOOL myread(MREADER *fp,void *a,size_t size)
{
	memcpy(a,mymod._base+mymod._cnt,size);
	mymod._cnt+=size;
	return size;
};
int myget(MREADER *fp)
{
	return *((UBYTE*)mymod._base+mymod._cnt++);
}
BOOL myeof(MREADER *fp)
{
	if (mymod._base+mymod._cnt>=(char*)mymod._flag)
	return 1;
	else
	return 0;
}

MREADER modr;
extern "C" int MikModSetup(void);
int MikModSetup(void)
{
	MODULE *cznmodule;
	MikMod_RegisterAllLoaders();
	MikMod_RegisterAllDrivers();
	md_mode |= DMODE_SOFT_MUSIC;
	MikMod_Init("");
	mymod._base=(char *)&modulefileptr;
	mymod._cnt=0;
	mymod._flag=(int)&modulefileendptr;
	modr.Seek=&myseek;
	modr.Tell=&mytell;
	modr.Read=&myread;
	modr.Get=&myget;
	modr.Eof=&myeof;
	cznmodule=Player_LoadGeneric(&modr,4,0);
	cznmodule->wrap=1;
	Player_Start(cznmodule);
	MikMod_Update();
//	module._bufsiz=(&modulefileendptr - &modulefileptr + 1);
//	return (int)((shit->_base)+(shit->_cnt++));

//	module=ML_LoadFP(&module);

	return 0;
};


